#include "map.h"

// Cre une nouvelle map SOL
void nouvelle_map(t_map *map)
{
    long n; // Compteur d'indice
    long x,y; // Compteurs de position
    long rouge, vert, bleu; // Contient la somme des valeurs des composantes de la couleur
    char str[255];
    str[0]=0;

    SDL_Color couleur; // Contient la couleur du pixel
    SDL_Rect crop; // Contient la position du coin haut gauche de la tile pour le calcul de couleur

/* Initialis dans le main
    // On dfinit le fichier de la map
    map->fichier=(char *)malloc(SAISIE_MAX+1); // On alloue le nom du fichier

    // On dfinit le fichier du Tileset (la grille des diffrents terrains)
    map->tileset.fichier=(char *)malloc(SAISIE_MAX+1);
*/

    // Remarque: On alloue la taille d'une saisie car cette valeur est susceptible d'tre modifie
    if (map->fichier[0]==0)
    {
        sprintf(map->fichier,"sansnom.map");// Nom du fichier, Nouvelle Map -> Sans Nom
    }

    if (map->tileset.fichier[0]==0)
    {
        // Remarque: On alloue l encore la taille d'une saisie car cette valeur est susceptible d'tre modifie
        sprintf(map->tileset.fichier,"map.png"); // Par dfaut: map.png
    }
    // Nouvelle map -> on cre juste les elements de base

/// Chargement du Tileset
    sprintf(str,"%s%s",RESSOURCES_DIR,map->tileset.fichier);
    map->tileset.image=IMG_Load(str);// On charge l'image du tileset
    if ( !map->tileset.image)
    {
        printf ( "IMG_Load: %s\n", IMG_GetError () ); // ERREUR

        sprintf(map->tileset.fichier,"map.png"); // Par dfaut: map.png

        sprintf(str,"%s%s",RESSOURCES_DIR,map->tileset.fichier);
        map->tileset.image=IMG_Load(str);// On charge l'image du tileset
        if ( !map->tileset.image )
        {
            printf ( "IMG_Load: L'image par dfaut n'a pas pu tre charge: %s\n", IMG_GetError () ); // ERREUR
        }
    }

    // Proprit du Tileset
    map->tileset.largeur=map->tileset.image->w / TILE_TAILLE;// nombre de tiles en largeur
    map->tileset.hauteur=map->tileset.image->h / TILE_TAILLE;// nombre de tiles en hauteur

/// Chargement des Effets
    // On dfinit le fichier des effets
    map->fx.fichier=(char *)malloc(SAISIE_MAX+1);
    strcpy(map->fx.fichier,FX_FICHIER); // Par dfaut, c'est "fx.png" mais pourra tre chang dans les options du jeu

    sprintf(str,"%s%s",RESSOURCES_DIR,map->fx.fichier);
    map->fx.image=IMG_Load(str);// On charge l'image des effets
       if ( !map->fx.image)
       {
          printf ( "IMG_Load: %s\n", IMG_GetError () ); // ERREUR
       }
    // On dfinit les proportions du fichier des effets
    map->fx.largeur=map->fx.image->w / TILE_TAILLE;// nombre de tiles en largeur
    map->fx.hauteur=map->fx.image->h / TILE_TAILLE;// nombre de tiles en hauteur


/// Paramtrage des Tiles
    // On alloue les tiles en fonction de la taille du Tileset
    map->tile=(t_tile*)malloc(map->tileset.largeur*map->tileset.hauteur*sizeof(t_tile)); // Nombre de tile : largeur * hauteur

    for (n=0;n<map->tileset.largeur*map->tileset.hauteur;n++) // POur chaque tile on initalise
    {
    /// Proprits de la Tile
        map->tile[n].type=SOL; // Par dfaut, le type de terrain est SOL (franchissable)
        map->tile[n].frame=0; // On dbute l'animation par la premire image
        map->tile[n].cout_pts=COUT_SOL; // Cot par dfaut de mouvement: 1
    /// Couleur de la Tile dans la minimap

    /* Remarque:
    La couleur n'est calcule que pour une nouvelle map... Sinon elle est charge depuis le fichier map.
    */
        // On initialise les sommes des composantes de la couleur de chaque pixel
        rouge=0;
        vert=0;
        bleu=0;

        // On rcupere le coin haut gauche du tile correspondant  N
        conversion_tile_tileset( n, map->tileset.largeur,map->tileset.hauteur, &crop);

        // Double boucle POUR, afin de faire la somme des composantes couleurs de chaque pixel de la tile
        for (x=0;x<TILE_TAILLE;x++) // Balayage Horizontal
        {
            for (y=0;y<TILE_TAILLE;y++) // Balayage Vertical
            {
                // On recupere les composantes RGB que l'on place directement dans couleur
                SDL_GetRGB(GetPixel( map->tileset.image,crop.x+x,crop.y+y), map->tileset.image->format, &couleur.r, &couleur.g, &couleur.b);
                // On ajoute la valeur de chaque composante
                rouge+=couleur.r;
                vert+=couleur.g;
                bleu+=couleur.b;

                if (x>=8 && x<24 && y>=8 && y<24)
                {
                    rouge+=couleur.r;
                    vert+=couleur.g;
                    bleu+=couleur.b;
                }

                if (x>=12 && x<20 && y>=12 && y<20)
                {
                    rouge+=couleur.r;
                    vert+=couleur.g;
                    bleu+=couleur.b;
                }
            }
        }
        // Puis on fait la moyenne, donnant une couleur approximative de la Tile pour la MINIMAP !
        map->tile[n].couleur.r=rouge/(32*32 + 16*16 + 8*8);
        map->tile[n].couleur.g=vert/(32*32 + 16*16 + 8*8);
        map->tile[n].couleur.b=bleu/(32*32 + 16*16 + 8*8);
    }

    if (strcmp(map->tileset.fichier,"map.png")==0 && map->tileset.largeur*map->tileset.hauteur == 68)
    {
        /// Tiles de Base
        // 0 -> Herbe
        // 1 -> Chemin de Pierre
        map->tile[2].cout_pts=COUT_FORET; // FORET
        map->tile[3].cout_pts=COUT_EAU; // EAU

        /// Bords de la Fort
        // 4 - Haut de la fort
        // 5 - Haut de la fort
        map->tile[6].cout_pts=COUT_FORET; // FORET
        map->tile[7].cout_pts=COUT_FORET; // FORET
        map->tile[8].cout_pts=COUT_FORET; // FORET
        map->tile[9].cout_pts=COUT_FORET; // FORET
        map->tile[10].cout_pts=COUT_FORET; // FORET
        map->tile[11].cout_pts=COUT_FORET; // FORET

        map->tile[15].type=CAMP; // CAMP
        map->tile[15].cout_pts=0; // CAMP

        map->tile[16].cout_pts=COUT_FORET; // FORET
        map->tile[17].cout_pts=COUT_FORET; // FORET
        map->tile[18].cout_pts=COUT_FORET; // FORET
        map->tile[19].cout_pts=COUT_FORET; // FORET
        map->tile[20].cout_pts=COUT_FORET; // FORET
        map->tile[21].cout_pts=COUT_FORET; // FORET
        map->tile[22].cout_pts=COUT_FORET; // FORET
        map->tile[23].cout_pts=COUT_FORET; // FORET

        /// Bords de l'eau
        map->tile[24].cout_pts=COUT_EAU; // EAU
        map->tile[25].cout_pts=COUT_EAU; // EAU
        // 26 -> Herbe
        // 27 -> Herbe
        map->tile[28].cout_pts=COUT_EAU; // EAU
        map->tile[29].cout_pts=COUT_EAU; // EAU
        map->tile[30].cout_pts=COUT_EAU; // EAU
        // 31 -> Herbe
        map->tile[32].cout_pts=COUT_EAU; // EAU
        map->tile[33].cout_pts=COUT_EAU; // EAU
        map->tile[34].cout_pts=COUT_EAU; // EAU
        map->tile[35].cout_pts=COUT_EAU; // EAU

        /// Bords des Falaises
        map->tile[36].type=OBSTACLE; // FALAISE
        map->tile[37].type=OBSTACLE; // FALAISE
        map->tile[38].type=OBSTACLE; // FALAISE
        map->tile[39].type=OBSTACLE; // FALAISE
        map->tile[40].type=OBSTACLE; // FALAISE
        map->tile[41].type=OBSTACLE; // FALAISE
        map->tile[42].type=OBSTACLE; // FALAISE
        map->tile[43].type=OBSTACLE; // FALAISE
        map->tile[44].type=OBSTACLE; // FALAISE
        map->tile[45].type=OBSTACLE; // FALAISE
        map->tile[46].type=OBSTACLE; // FALAISE
        map->tile[47].type=OBSTACLE; // FALAISE
        map->tile[48].type=OBSTACLE; // FALAISE
        map->tile[49].type=OBSTACLE; // FALAISE
        map->tile[50].type=OBSTACLE; // FALAISE
        map->tile[51].type=OBSTACLE; // FALAISE
        map->tile[52].type=OBSTACLE; // FALAISE
        map->tile[53].type=OBSTACLE; // FALAISE
        map->tile[54].type=OBSTACLE; // FALAISE
        map->tile[55].type=OBSTACLE; // FALAISE
        // 56 -> Pente entre 2 falaises
        // 57 -> Pente entre 2 falaises
        // 58 -> Pente entre 2 falaises
        // 59 -> Pente entre 2 falaises

        /// Dcorations
        map->tile[60].type=OBSTACLE; // PANCARTE
        map->tile[61].type=OBSTACLE; // TONNEAU
        // 62 -Petites Pierres
        map->tile[63].cout_pts=2; // Grosses Pierres -> Ralenti
        map->tile[64].type=OBSTACLE; // ROCHER
        map->tile[65].type=OBSTACLE; // BUISSON
        // 66 -> Pont
        // 67 -> Pont


    }


    // La taille de la map est passe en argument dans la fonction
    if (map->largeur>255) {map->largeur=255;}
    if (map->hauteur>255) {map->hauteur=255;}
    if (map->largeur<16) {map->largeur=16;}
    if (map->hauteur<16) {map->hauteur=16;}
    // On initialise les cases de la map
    map->cases=(t_map_case**)malloc(map->hauteur*sizeof(t_map_case*)); // Allocation des pointeurs sur les lignes de cases
    for (y=0;y<map->hauteur;y++)// On balaye d'abord  la vertical
    {
         map->cases[y]=(t_map_case*)malloc(map->largeur*sizeof(t_map_case)); // Allocation des pointeurs sur les cases
        for (x=0;x<map->largeur;x++) // Puis  l'horizontal
        {
            map->cases[y][x].tile=0; // Par dfaut, on met  0, mais notre herbe de map.png, se trouve en 15, donc pour le moment, on met 15
        }
    }
}

// Charge une map a partir d'un fichier .map
void charger_map(t_map *map)
{
    long n,x,y,tilemax; // Compteurs d'indice, de position, et nombre de tiles.
    char kmap_str[5]; // Contient la chaine de caractre d'indication du fichier map
    char c; // Contient l'octet prcdemment obtenu
    char str[255];
    str[0]=0;

    kmap_str[0]=0; //On initialise la chaine de caractre du KMAP
    FILE* fichier=NULL; // Pointeur sur le fichier .map  charger

/* Initialis dans le main
    // On dfinit le fichier de la map
    map->fichier=(char *)malloc(SAISIE_MAX+1); // On alloue le nom du fichier
*/

    if (map->fichier[0]!=0) // Si un fichier a t pass en argument
    {
        sprintf(str,"%s%s",MAPS_DIR,map->fichier);
        fichier=fopen(str,"rb"); // On ouvre le fichier en LECTURE BINAIRE SEULE
    }

    if (fichier) // Si un fichier a pu tre ouvert alors On charge ^^
    {
        fscanf(fichier,"%4s",kmap_str); // On rcupre les 4 premiers caractres


        if (strcmp("KMAP", kmap_str) == 0) // On verifie que le fichier commence bien par KMAP, preuve que le fichier est bien une map
        {
        /// CHARGEMENT DU TILESET
        /*
            // On dfinit le fichier du Tileset (la grille des diffrents terrains)
            map->tileset.fichier=(char *)malloc(SAISIE_MAX+1); // On alloue le nom du fichier
        */
            // Remarque: On alloue l encore la taille d'une saisie car cette valeur est susceptible d'tre modifie
            n=0;// On initialise le compteur d'indice

            // Boucle Do...While pour capturer le nom du fichier
            do
            {
                c=fgetc(fichier); // On rcupre le caractre
                map->tileset.fichier[n]=c; // Et on le rajoute au nom du fichier
                n++; // ON n'oublie pas d'incrmenter l'indice
            }while(c!=0); // Le caractre EOT permet de dfinir la fin du nom du fichier

        /// Chargement du Tileset

            sprintf(str,"%s%s",RESSOURCES_DIR,map->tileset.fichier);
            map->tileset.image=IMG_Load(str);// On charge l'image du tileset
            if ( !map->tileset.image)
            {
                printf ( "IMG_Load: %s\n", IMG_GetError () ); // ERREUR

                sprintf(map->tileset.fichier,"map.png"); // Par dfaut: map.png


                sprintf(str,"%s%s",RESSOURCES_DIR,map->tileset.fichier);
                map->tileset.image=IMG_Load(str);// On charge l'image du tileset
                if ( !map->tileset.image )
                {
                    printf ( "IMG_Load: L'image par dfaut n'a pas pu tre charge: %s\n", IMG_GetError () ); // ERREUR
                }
            }

            // On dfinit la largeur et la hauteur du tileset
            map->tileset.largeur=map->tileset.image->w / TILE_TAILLE;// nombre de tiles en largeur
            map->tileset.hauteur=map->tileset.image->h / TILE_TAILLE;// nombre de tiles en hauteur

            // On dfinit le fichier des effets
            map->fx.fichier=(char *)malloc(SAISIE_MAX+1);
            strcpy(map->fx.fichier,FX_FICHIER); // Par dfaut, c'est "fx.png" mais pourra tre chang dans les options du jeu

            sprintf(str,"%s%s",RESSOURCES_DIR,map->fx.fichier);
            map->fx.image=IMG_Load(str);// On charge l'image des effets
               if ( !map->fx.image)
               {
                  printf ( "IMG_Load: %s\n", IMG_GetError () ); // ERREUR Lors du chargement
                  exit (EXIT_FAILURE);
               }


            // On dfinit les proportions du fichier des effets
            map->fx.largeur=map->fx.image->w / TILE_TAILLE;// nombre de tiles en largeur
            map->fx.hauteur=map->fx.image->h / TILE_TAILLE;// nombre de tiles en hauteur

            tilemax=(long)fgetc(fichier); // L'octet suivant contient le nombre de tiles

            if (tilemax!=map->tileset.largeur*map->tileset.hauteur) // Si le tileset ne contient pas le mme nombre de tiles que celles definies dans la map
            {
                printf ( "ERREUR la taille des tilesets ne correspond pas !!!"); // ERREUR
                exit (EXIT_FAILURE); // Et arrt
            }

            // On alloue les tiles en fonction de la taille du Tileset
            map->tile=(t_tile*)malloc(tilemax*sizeof(t_tile));
            for (n=0;n<tilemax;n++) // On parcourt toutes les tiles
            {
                map->tile[n].type=fgetc(fichier); // Le premier octet dfinit le type de terrain
                map->tile[n].frame=0; // On commence l'animation  la premire image
                map->tile[n].cout_pts=fgetc(fichier); // L'octet suivant dfinit le cout en points de mouvement

                // Les 3 octets d'aprs dfinissent les composantes de la couleur de la tile dans la minimap
                map->tile[n].couleur.r=fgetc(fichier); // D'abord le Rouge
                map->tile[n].couleur.g=fgetc(fichier); // Puis le Vert
                map->tile[n].couleur.b=fgetc(fichier); // Et enfin le Bleu

                // Le mme format est rept pour chaque tile
            }


            // La taille de la map est stocke sur 2 octets (255*255 max)
            map->largeur=fgetc(fichier); // 1octet pour la Taille de la map en largeur
            map->hauteur=fgetc(fichier); // 1octet pour la Taille de la map en hauteur

            // On initialise les cases de la map

            map->cases=(t_map_case**)malloc(map->hauteur*sizeof(t_map_case*)); // Allocation des pointeurs sur les lignes de cases

            // Les types de tile sont placs  la suite de gauche  droite, et de bas en haut
            for (y=0;y<map->hauteur;y++) // On explore donc tout ligne par ligne
            {
                 map->cases[y]=(t_map_case*)malloc(map->largeur*sizeof(t_map_case)); // Allocation des pointeurs sur les cases
                for (x=0;x<map->largeur;x++) //  DE gauche  droite
                {
                    map->cases[y][x].tile=fgetc(fichier);// 1octet pour le type de tile de la case
                }
            }

            c=fgetc(fichier); // Rcupration du caractre sens tre le dernier
            if(!feof(fichier)) // Si ce caractre n'tait pas le caractre EOF
            {
                printf("Chargement de la MAP: Fin de fichier non atteinte"); // On considre qu'il y a une incohrence dans le fichier
                exit (EXIT_FAILURE); // Alors on quitte
            }
        }
        else // Si les 4 permieres caractres ne sont pas "KMAP"
        {
            printf("Chargement de la MAP: le filetype ne correspond pas "); // Le fichier n'est donc pas une map
            exit (EXIT_FAILURE); // Alors on quitte
        }

        fclose(fichier); // On ferme le fichier
    }
    else // Si le fichier n'a pas pu tre charg
    {
        nouvelle_map(map);
    }
}

// Sauvegarde une map dans un fichier .map
long sauvegarder_map(t_map *map)
{
    long x,y; // Compteurs de Position
    FILE* fichier; // Pointeur sur le fichier
    char str[255];
    str[0]=0;

    sprintf(str,"%s%s",MAPS_DIR,map->fichier);
    fichier=fopen(str,"w+b"); // On ouvre le fichier en ECRITURE BINAIRE SEULE

    if (fichier) // Si le fichier est ouvert
    {
        fprintf(fichier,"KMAP");// On definit le filetype par ces 4 petits caractres qui prouvent que c'est une map (4 octets)
        fprintf(fichier,"%s%c",map->tileset.fichier,0); // On dfinit le tileset (strlen + 1[EOT] octets)
        fprintf(fichier,"%c",(char)(map->tileset.largeur*map->tileset.hauteur) );// Nombre de tiles (1octet) (VALEUR MAX 255)

        // On ajoute les proprits de chaque tile
        for(x=0;x<map->tileset.largeur*map->tileset.hauteur;x++)
        {
            fprintf(fichier,"%c",(char)map->tile[x].type);// Type de terrain de la tile (1 octet)
            fprintf(fichier,"%c",(char)map->tile[x].cout_pts);// Points de mouvement que consomme la tile (1 octet)
            fprintf(fichier,"%c%c%c",(char)map->tile[x].couleur.r,(char)map->tile[x].couleur.g,(char)map->tile[x].couleur.b);// Couleur de la tile sur la minimap (3 octets)
        }
        // Largeur de la map (1 octet) MAX 255
        fprintf(fichier,"%c", (char)map->largeur);
        // Hauteur de la map (1 octet) MAX 255
        fprintf(fichier,"%c", (char)map->hauteur);

        // On indique le type de tile de chaque case
        for(y=0;y<map->hauteur;y++) // De bas en haut, ligne par ligne
        {
            for(x=0;x<map->largeur;x++) // de gauche  droite
            {
                fprintf(fichier,"%c",(char)map->cases[y][x].tile);// Numro de la tile (1 octet)
            }
        }

        return 1;
        // Confirmation de sauvegarde  Ajouter
    }
    else
    {
        printf("Impossible d'ouvrir le fichier %s pour la sauvegarde. Sauvegarde Annule",map->fichier); // Erreur lors de l'ouverture du fichier
        return 0;
        // On ne quitte pas...
    }

    fclose(fichier);// On libre le fichier
}

 // Supprime les donnes de l'interface
void liberer_map(t_map * map) //dite le 25/02/2010  13:45 par Loc
{
    long y; // Compteur de ligne
    free(map->fichier); // On libre le nom du fichier de la Map
    free(map->tileset.fichier); // On libre le nom du fichier du Tileset
    SDL_FreeSurface(map->tileset.image); // On libre la surface du Tileset
    free(map->fx.fichier);  // On libre le nom du fichier des effets
    SDL_FreeSurface(map->fx.image); // On libre la surface des effets
    free(map->tile); // On libre la liste des tiles

    // On explore les lignes de la map
    for (y=0;y<map->hauteur;y++)
    {
        free(map->cases[y]); // On libre les cases de la ligne
    }
    free(map->cases); // Puis on libre les lignes

    // la structure de la map sera libre automatiquement  la fin du main
}

// Blitte la map sur l'cran
void afficher_map (t_map* map,t_interface* interface)
{
    long x,y; // Compteurs de position
    SDL_Rect position, crop; // Coordonnes de positionnement, et de rognage

    // On rogne le tileset pour n'avoir qu'une seule tile....
    crop.h=TILE_TAILLE;
    crop.w=TILE_TAILLE;
    SDL_FillRect(interface->gui[0]->image, 0, SDL_MapRGB(interface->fenetre->format, 0,0,0)); // On efface l'cran

    // On affiche ligne par ligne, de gauche  droite, de bas en haut
    for (y=(interface->gui[0]->crop.y/TILE_TAILLE);y<=((interface->gui[0]->crop.y+interface->gui[0]->crop.h)/TILE_TAILLE);y++) // On ne prend que les tiles qui sont dans l'cran
    {
        for (x=(interface->gui[0]->crop.x/TILE_TAILLE);x<=((interface->gui[0]->crop.x+interface->gui[0]->crop.w)/TILE_TAILLE)+1;x++)// On ne prend que les tiles qui sont dans l'cran
        {
            position.x=x*TILE_TAILLE-interface->gui[0]->crop.x; // On transforme les coordonnes de la tile en coordonnes en pixels
            position.y=y*TILE_TAILLE-interface->gui[0]->crop.y;   // On transforme les coordonnes de la tile en coordonnes en pixels

            if (x>=0 && y>=0 && x<map->largeur && y<map->hauteur) // Si les coordonnes sont bien celles d'une tile de la map (voir remarque ci dessous)
            {
                /* Remarque
                Cette condition est necessaire car on peut si on le veut, permettre  l'cran de sortir de la map...
                */

                // On rcupre les coordonnes de rognage de la tile identifie par son numro
                conversion_tile_tileset(map->cases[y][x].tile,map->tileset.largeur,map->tileset.hauteur,&crop);

                // On blitte cette le tileset rogne (donc la tile),  la bonne position sur l'ecran
                SDL_BlitSurface(map->tileset.image, &crop, interface->gui[0]->image, &position);

                if (x==interface->curseur.x && y==interface->curseur.y)// Si la tile courante est survole par le pointeur
                {
                    // On rcupre les coordonnes de rognage de la tile d'effet n0 (surlignage) -> le blanc 50%
                    conversion_tile_tileset(0,map->fx.largeur,map->fx.hauteur,&crop);
                    // On blitte l'effet par dessus la tile de terrain
                    SDL_BlitSurface(map->fx.image, &crop, interface->gui[0]->image, &position);
                }
            }
        }
    }
}

// Actualise la minimap  partir des donnes de la map
void actualiser_minimap (t_map* map, t_interface* interface) //dite le 25/02/2010  16:08 par Loc
{

    long minimap_element;
    SDL_Surface* pixel; //Contient un unique pixel
    SDL_Rect position; //Position du pixel sur la minimap
    double ratio; //Ratio d'agrandissement
    long x, y, i, j; //Positions sur la carte / avancement sur la minimap
    long offset_x, offset_y; //Utiliss pour centrer la minimap
    double r[160][160], g[160][160], b[160][160], coeff[160][160]; //Contiennent les calculs en cours
    double coeff_x, coeff_y, temp_x, temp_y, temp;

    minimap_element=obtenir_element(interface,MINIMAP);

    if (minimap_element!=-1)
    {
        //Calcul du ratio optimal pour l'agrandissement
        if(map->largeur < map->hauteur)
        {
            ratio = 160.0 / map->hauteur;
            offset_x = (160.0 - map->largeur * ratio) / 2;
            offset_y = 0;
        }
        else
        {
            ratio = 160.0 / map->largeur;
            offset_x = 0;
            offset_y = (160.0 - map->hauteur * ratio) / 2;
        }

        //Initialisation des couleurs : noir
        SDL_FillRect(interface->gui[minimap_element]->image, NULL, SDL_MapRGB(interface->gui[minimap_element]->image->format, 0, 0, 0));
        for (y = 0; y < 160; y++)
        {
            for (x = 0; x < 160; x++)
            {
                r[y][x] = 0.0; g[y][x] = 0.0; b[y][x] = 0.0; coeff[y][x] = 0.0;
            }
        }

        //Pour chaque case de la carte
        //Pour chaque ligne
        for(y = 0; y < map->hauteur; y++)
        {
            i = 0;
            coeff_y = (long)(y * ratio) + 1 - y * ratio;
            do
            {
                if(coeff_y > 1) {temp_y = 1.0;}
                else {temp_y = coeff_y;}

                //Pour chaque colonne
                for(x = 0; x < map->largeur; x++)
                {
                    j = 0;
                    coeff_x = (long)(x * ratio) + 1 - x * ratio;
                    do
                    {
                        if(coeff_x > 1) {temp_x = 1.0;}
                        else {temp_x = coeff_x;}
                        temp = temp_x * temp_y;
                        coeff[(long)(y * ratio) + offset_y + i][(long)(x * ratio) + offset_x + j] += temp;
                        r[(long)(y * ratio) + offset_y + i][(long)(x * ratio) + offset_x + j] += map->tile[(long)(map->cases[y][x].tile)].couleur.r * temp;
                        g[(long)(y * ratio) + offset_y + i][(long)(x * ratio) + offset_x + j] += map->tile[(long)(map->cases[y][x].tile)].couleur.g * temp;
                        b[(long)(y * ratio) + offset_y + i][(long)(x * ratio) + offset_x + j] += map->tile[(long)(map->cases[y][x].tile)].couleur.b * temp;
                        if(j == 0) {coeff_x = (x + 1) * ratio - (long)(x * ratio) - 1;}
                        else {coeff_x -= 1.0;}
                        j++;
                    }while(coeff_x > 0.01);
                }

                if(i == 0) {coeff_y = (y + 1) * ratio - (long)(y * ratio) - 1;}
                else {coeff_y -= 1.0;}
                i++;
            }while(coeff_y > 0.01);
        }

        //On range le rsultat dans la surface prvue pour la minimap
        pixel = SDL_CreateRGBSurface(SDL_HWSURFACE, 1, 1, BITSPERPIXEL, 0, 0, 0, 0);
        for (position.y = 0; position.y < 160; position.y++)
        {
            for (position.x = 0; position.x < 160; position.x++)
            {
                if(coeff[position.y][position.x] != 0)
                {
                    SDL_FillRect(pixel, NULL, SDL_MapRGB(interface->gui[minimap_element]->image->format, r[position.y][position.x] / coeff[position.y][position.x], g[position.y][position.x] / coeff[position.y][position.x], b[position.y][position.x] / coeff[position.y][position.x]));
                    SDL_BlitSurface(pixel, 0, interface->gui[minimap_element]->image, &position);
                }
            }
        }
        SDL_FreeSurface(pixel);
        return;
    }
    else
    {
        printf("Impossible d'obtenir l'element de la minimap");
    }

}

 // Recupre les coordonnes de rognage d'un tileset  partir du numro de tile
void conversion_tile_tileset(long tile, long largeur,long hauteur, SDL_Rect *crop)
{
    /// A changer: On ne passera plus largeur et hauteur, mais directement le pointeur sur le tileset !!!
    crop->x = (tile%largeur)*TILE_TAILLE;// Bord gauche de la tile
    crop->y = (tile/largeur)*TILE_TAILLE;// Bord haut de la tile

}

// Obtient les coordonnes de la case situe sous le pointeur de la souris
void obtenir_case(t_interface* interface)
{
    interface->curseur.x=(interface->gui[0]->crop.x+interface->pointeur.x); // Position du pointeur dans la map en pixels selon X
    interface->curseur.y=(interface->gui[0]->crop.y+interface->pointeur.y); // Position du pointeur dans la map en pixels selon Y

    if (interface->curseur.x<0 || interface->curseur.y<0) // Si la position est ngative (en dehors de la map)
    {
       interface->curseur.x=-1; // Alors on donne x=-1
       interface->curseur.y=-1; // Et y=-1 pour indiquer que le curseur n'est pas sur la map...
    }
    else // Sinon
    {
         // On transforme la coordonnes pixels en coordonnes cases en divisant par la taille d'une tile
        interface->curseur.x/=TILE_TAILLE; // Coordonnes en X
        interface->curseur.y/=TILE_TAILLE; // Coordonnes en Y
    }
}

long rand_coef(long coef)
{
    long n;

    n=rand()%1000;

    if (n<coef)
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

void generer_map(t_map* map, long BORDURE, long RAYON_MAX, long EAU_COEF, long FORET_COEF, long DECO_COEF)
{
    long x,y;
    long a, b;
    long coef;
    long rayon;
    long mask;

// On cre un map temporaire
    t_map_case** cases,** foret;

    cases=(t_map_case**)malloc(map->hauteur*sizeof(t_map_case*)); // Allocation des pointeurs sur les lignes de cases
    for (y=0;y<map->hauteur;y++)// On balaye d'abord  la vertical
    {
         cases[y]=(t_map_case*)malloc(map->largeur*sizeof(t_map_case)); // Allocation des pointeurs sur les cases
    }

    foret=(t_map_case**)malloc(map->hauteur*sizeof(t_map_case*)); // Allocation des pointeurs sur les lignes de cases
    for (y=0;y<map->hauteur;y++)// On balaye d'abord  la vertical
    {
         foret[y]=(t_map_case*)malloc(map->largeur*sizeof(t_map_case)); // Allocation des pointeurs sur les cases
    }

    srand ( time(NULL) );

//On cre que de l'eau sur laquelle on va mettre des points d'herbe
    for(y=0;y<map->hauteur;y++)
    {
        for(x=0;x<map->largeur;x++)
        {
            map->cases[y][x].tile=3;
            cases[y][x].tile=0;

            coef=EAU_COEF;
            if (x < BORDURE)
            {
                coef=coef*(x/(double)BORDURE);
            }

            if (x > map->largeur-BORDURE)
            {
                coef=coef*((map->largeur-x-1)/(double)BORDURE);
            }

            if (y < BORDURE)
            {
                coef=coef*(y/(double)BORDURE);
            }

            if (y > map->hauteur - BORDURE)
            {
                coef=coef*((map->hauteur-y-1)/(double)BORDURE);
            }

            if (rand_coef(coef))
            {
                cases[y][x].tile=1;
            }
        }
    }

//On va largir chaque point de terre avec n rayon au hasard
    for(y=0;y<map->hauteur;y++)
    {
        for(x=0;x<map->largeur;x++)
        {
            if (cases[y][x].tile==1)
            {
                rayon=rand()%RAYON_MAX +1;

                for (a=-rayon;a<=rayon;a++)
                {
                    for (b=-rayon;b<=rayon;b++)
                    {
                        if( (a*a + b*b) < rayon)
                        {
                            if ( x+b >= 0 && y+a >= 0 && x+b < map->largeur && y+a < map->hauteur )
                            {
                                map->cases[y+a][x+b].tile=0;
                            }
                        }
                    }
                }
            }
        }
    }

// On va ensuite mettre les bords de l'eau
rayon=0;
while(!rayon)
{
    rayon=1;

    for(y=0;y<map->hauteur;y++)
    {
        for(x=0;x<map->largeur;x++)
        {
            mask=0;

            // Si la case n'est pas de l'eau
            if (map->cases[y][x].tile!=3)
            {
                // Pour chaque case, on regarde dans les 8 directions si il y a une case d'eau
                // 1 - GAUCHE
                // 2 - DROITE
                // 4 - HAUT
                // 8 - BAS
                // 16- GAUCHE-HAUT
                // 32- GAUCHE-BAS
                // 64- DROITE-HAUT
                //128- DROITE-BAS

                if ( x-1 >= 0 )
                {
                    if (map->cases[y][x-1].tile==3){mask+=1;}
                    if ( y-1 >= 0 )
                    {
                        if (map->cases[y-1][x-1].tile==3){mask+=16;}
                    }
                    if ( y+1 < map->hauteur)
                    {
                        if (map->cases[y+1][x-1].tile==3){mask+=32;}
                    }
                }
                else
                {
                    mask+=1;
                    mask+=16;
                    mask+=32;
                }
                if ( x+1 < map->largeur)
                {
                    if (map->cases[y][x+1].tile==3){mask+=2;}

                    if ( y-1 >= 0 )
                    {
                        if (map->cases[y-1][x+1].tile==3){mask+=64;}
                    }
                    if ( y+1 < map->hauteur)
                    {
                        if (map->cases[y+1][x+1].tile==3){mask+=128;}
                    }
                }
                else
                {
                    mask+=2;
                    mask+=64;
                    mask+=128;
                }

                if ( y-1 >= 0 )
                {
                    if (map->cases[y-1][x].tile==3){mask+=4;}
                }
                else
                {
                    mask+=4;
                }

                if ( y+1 < map->hauteur)
                {
                    if (map->cases[y+1][x].tile==3){mask+=8;}
                }
                else
                {
                    mask+=8;
                }

                // En fonction des cases alentours, on place un case correpondante
                if (mask==128)
                {
                    map->cases[y][x].tile=24;
                }
                else if (mask==32)
                {
                    map->cases[y][x].tile=25;
                }
                else if (mask==64)
                {
                    map->cases[y][x].tile=26;
                }
                else if (mask==16)
                {
                    map->cases[y][x].tile=27;
                }
                else if (mask==(2+8) || mask==(2+8+128) || mask==(2+8+32)  || mask==(2+8+128+32) || mask==(2+8+64) || mask==(2+8+128+64) || mask==(2+8+32+64) || mask==(2+8+128+32+64))
                {
                    map->cases[y][x].tile=32;
                }
                else if (mask==(1+8) ||mask==(1+8+32) || mask==(1+8+16) || mask==(1+8+32+16) || mask==(1+8+128) || mask==(1+8+32+128) || mask==(1+8+16+128) || mask==(1+8+32+16+128))
                {
                    map->cases[y][x].tile=33;
                }
                else if (mask==(4+2) ||mask==(4+2+64) || mask==(4+2+16) || mask==(4+2+16+64) || mask==(4+2+128)  || mask==(4+2+64+128)  || mask==(4+2+16+128) || mask==(4+2+16+64+128))
                {
                    map->cases[y][x].tile=34;
                }
                else if (mask==(1+4) || mask==(1+4+16)  || mask==(1+4+32) || mask==(1+4+16+32) || mask==(1+4+64) || mask==(1+4+16+64)  || mask==(1+4+32+64) || mask==(1+4+16+32+64))
                {
                    map->cases[y][x].tile=35;
                }
                else if (mask==8 || mask==(8+32) || mask==(8+128) || mask==(8+32+128))
                {
                    map->cases[y][x].tile=28;
                }
                else if (mask==2 || mask==(2+64) || mask==(2+128) || mask==(2+64+128))
                {
                    map->cases[y][x].tile=29;
                }
                else if (mask==1 || mask==(1+16) || mask==(1+32) || mask==(1+16+32))
                {
                    map->cases[y][x].tile=30;
                }
                else if (mask==4 || mask==(4+16) || mask==(4+64) || mask==(4+16+64))
                {
                    map->cases[y][x].tile=31;
                }
                else if (mask == 0)
                {
                    // Si la case est entoure d'herbe, on la laisse telle quelle
                }
                else
                {
                    // Si en revanche elle ne correspond  aucune image de tileset, alors on la tranforme en eau (ce qui tend  arranger le problme)
                    map->cases[y][x].tile=3;
                    rayon = 0; // Parcontre, on indique qu'il faut refaire la boucle... pour voir si il n'y a pas d'autres problmes
                    // Ainsi, on continue jusqu' ce qu'il n'y ait plus de problmes
                }
            }
        }
    }
}

    for(y=0;y<map->hauteur;y++)
    {
        for(x=0;x<map->largeur;x++)
        {
            foret[y][x].tile=0;
            cases[y][x].tile=0;

            coef=FORET_COEF;

            if (rand_coef(coef))
            {
                if (map->cases[y][x].tile==0)
                {
                    cases[y][x].tile=1;
                }
            }
        }
    }

//On va largir chaque point de terre avec n rayon au hasard
    for(y=0;y<map->hauteur;y++)
    {
        for(x=0;x<map->largeur;x++)
        {
            if (cases[y][x].tile==1)
            {
                rayon=rand_coef(500)*(RAYON_MAX/6.0) + rand_coef(300)*(RAYON_MAX/4.0) + rand_coef(100)*(RAYON_MAX/2.0) + 3;

                for (a=-rayon;a<=rayon;a++)
                {
                    for (b=-rayon;b<=rayon;b++)
                    {
                        if( (a*a + b*b) < rayon)
                        {
                            if ( x+b >= 0 && y+a >= 0 && x+b < map->largeur && y+a < map->hauteur )
                            {
                                if (map->cases[y+a][x+b].tile==0 && map->cases[y+a+1][x+b].tile==0)
                                {
                                       foret[y+a][x+b].tile=2;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

// On va ensuite mettre les bords de l'eau
rayon=0;
while(!rayon)
{
    rayon=1;

    for(y=0;y<map->hauteur;y++)
    {
        for(x=0;x<map->largeur;x++)
        {
            mask=0;

            // Si la case n'est pas de l'eau
            if (foret[y][x].tile!=0 &&
                foret[y][x].tile!=12 &&
                foret[y][x].tile!=13 &&
                foret[y][x].tile!=14 &&
                foret[y][x].tile!=18 &&
                foret[y][x].tile!=19 &&
                foret[y][x].tile!=22 &&
                foret[y][x].tile!=23)
            {
                // Pour chaque case, on regarde dans les 8 directions si il y a une case d'eau
                // 1 - GAUCHE
                // 2 - DROITE
                // 4 - HAUT
                // 8 - BAS
                // 16- GAUCHE-HAUT
                // 32- GAUCHE-BAS
                // 64- DROITE-HAUT
                //128- DROITE-BAS

                if ( x-1 >= 0 )
                {
                    if (foret[y][x-1].tile==0){mask+=1;}
                    if ( y-1 >= 0 )
                    {
                        if (foret[y-1][x-1].tile==0){mask+=16;}
                    }
                    if ( y+1 < map->hauteur)
                    {
                        if (foret[y+1][x-1].tile==0){mask+=32;}
                    }
                }
                else
                {
                    mask+=1;
                    mask+=16;
                    mask+=32;
                }
                if ( x+1 < map->largeur)
                {
                    if (foret[y][x+1].tile==0){mask+=2;}

                    if ( y-1 >= 0 )
                    {
                        if (foret[y-1][x+1].tile==0){mask+=64;}
                    }
                    if ( y+1 < map->hauteur)
                    {
                        if (foret[y+1][x+1].tile==0){mask+=128;}
                    }
                }
                else
                {
                    mask+=2;
                    mask+=64;
                    mask+=128;
                }

                if ( y-1 >= 0 )
                {
                    if (foret[y-1][x].tile==0){mask+=4;}
                }
                else
                {
                    mask+=4;
                }

                if ( y+1 < map->hauteur)
                {
                    if (foret[y+1][x].tile==0){mask+=8;}
                }
                else
                {
                    mask+=8;
                }

                // En fonction des cases alentours, on place un case correpondante
                if (mask==128)
                {
                    foret[y][x].tile=16;
                }
                else if (mask==32)
                {
                    foret[y][x].tile=17;
                }
                else if (mask==64)
                {
                    foret[y][x].tile=20;
                }
                else if (mask==16)
                {
                    foret[y][x].tile=21;
                }
                else if (mask==(2+8) || mask==(2+8+128) || mask==(2+8+32)  || mask==(2+8+128+32) || mask==(2+8+64) || mask==(2+8+128+64) || mask==(2+8+32+64) || mask==(2+8+128+32+64))
                {
                    foret[y][x].tile=7;
                }
                else if (mask==(1+8) ||mask==(1+8+32) || mask==(1+8+16) || mask==(1+8+32+16) || mask==(1+8+128) || mask==(1+8+32+128) || mask==(1+8+16+128) || mask==(1+8+32+16+128))
                {
                    foret[y][x].tile=6;
                }
                else if (mask==(4+2) ||mask==(4+2+64) || mask==(4+2+16) || mask==(4+2+16+64) || mask==(4+2+128)  || mask==(4+2+64+128)  || mask==(4+2+16+128) || mask==(4+2+16+64+128))
                {
                    foret[y][x].tile=5;
                }
                else if (mask==(1+4) || mask==(1+4+16)  || mask==(1+4+32) || mask==(1+4+16+32) || mask==(1+4+64) || mask==(1+4+16+64)  || mask==(1+4+32+64) || mask==(1+4+16+32+64))
                {
                    foret[y][x].tile=4;
                }
                else if (mask==8 || mask==(8+32) || mask==(8+128) || mask==(8+32+128))
                {
                    foret[y][x].tile=11;
                }
                else if (mask==2 || mask==(2+64) || mask==(2+128) || mask==(2+64+128))
                {
                    foret[y][x].tile=10;
                }
                else if (mask==1 || mask==(1+16) || mask==(1+32) || mask==(1+16+32))
                {
                    foret[y][x].tile=9;
                }
                else if (mask==4 || mask==(4+16) || mask==(4+64) || mask==(4+16+64))
                {
                    foret[y][x].tile=8;
                }
                else if (mask == 0)
                {
                    // Si la case est entoure d'herbe, on la laisse telle quelle
                }
                else
                {
                    // Si en revanche elle ne correspond  aucune image de tileset, alors on la tranforme en eau (ce qui tend  arranger le problme)
                    foret[y][x].tile=0;
                    rayon = 0; // Parcontre, on indique qu'il faut refaire la boucle... pour voir si il n'y a pas d'autres problmes
                    // Ainsi, on continue jusqu' ce qu'il n'y ait plus de problmes
                }
            }
        }
    }
}

    for(y=0;y<map->hauteur;y++)
    {
        for(x=0;x<map->largeur;x++)
        {
            if (foret[y][x].tile==11)
            {
                    foret[y+1][x].tile=13;
            }
            else if (foret[y][x].tile==6 || foret[y][x].tile==23 )
            {
                    foret[y+1][x].tile=12;
            }
            else if (foret[y][x].tile==7 || foret[y][x].tile==22 )
            {
                    foret[y+1][x].tile=14;
            }
            else if (foret[y][x].tile==16)
            {
                if(foret[y+1][x].tile==10)
                {
                    foret[y+1][x].tile=18;
                }
                else
                {
                    foret[y+1][x].tile=22;
                }
            }
            else if (foret[y][x].tile==17)
            {
                if(foret[y+1][x].tile==9)
                {
                    foret[y+1][x].tile=19;
                }
                else
                {
                    foret[y+1][x].tile=23;
                }
            }

            if (map->cases[y][x].tile==0)
            {
                map->cases[y][x].tile=foret[y][x].tile;
            }
        }
    }



    for(y=0;y<map->hauteur;y++)
    {
        for(x=0;x<map->largeur;x++)
        {
            coef=DECO_COEF;

            if (rand_coef(coef))
            {
                if (map->cases[y][x].tile==0)
                {
                    rayon=rand()%100;

                    if (rayon<30)
                    {
                        map->cases[y][x].tile=65;
                    }
                    else if (rayon<50)
                    {
                        map->cases[y][x].tile=63;
                    }
                    else if (rayon<70)
                    {
                        map->cases[y][x].tile=62;
                    }
                    else if (rayon<85)
                    {
                        map->cases[y][x].tile=64;
                    }
                    else if (rayon<93)
                    {
                        map->cases[y][x].tile=61;
                    }
                    else
                    {
                        map->cases[y][x].tile=60;
                    }
                }
            }
        }
    }

    // On explore les lignes de la map
    for (y=0;y<map->hauteur;y++)
    {
        free(cases[y]); // On libre les cases de la ligne
        free(foret[y]); // On libre les cases de la ligne
    }
    free(cases); // Puis on libre les lignes
    free(foret); // Puis on libre les lignes
};
